function [residual, g1, g2, g3] = World_Economy_Cartel_Fracking_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 76, 1);

%
% Model equations
%

T18 = exp(y(19))-params(9)*exp(y(18))^(1+params(8))/(1+params(8));
T21 = T18^(-params(14));
T36 = params(25)^(-1);
T39 = exp(y(22));
T63 = y(55)*(-exp(y(1)))+exp(y(1))*y(40)+T36*y(48)*(-(T39*exp(y(1))*exp(y(11))))+T36*y(51)*(-(exp(y(1))*T39))+T36*y(52)*(-(T39*exp(y(1))*exp(y(29))));
T79 = params(12)^(1-params(4));
T98 = params(13)^(1-params(4));
T134 = exp(y(1))*exp(y(4))-exp(y(4))*params(6)*exp(y(38)-y(24))^(params(5)-1);
T188 = exp(y(6))*y(58)+params(25)*y(44)*exp(y(6))*params(6)*exp(params(5)*y(10))+params(25)*y(58)*(-(exp(y(6))*(1-exp((-y(24)))*exp(y(10)))))+params(25)*y(64)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
T211 = exp(y(7))*y(56)+params(25)*y(44)*exp(y(7))*params(6)*exp(y(11)*params(5))+params(25)*y(56)*(-(exp(y(7))*(1-exp(y(11)))))+params(25)*y(62)*(-(exp(y(11))*exp(y(7))));
T252 = params(25)*y(64)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))))+params(25)*y(44)*exp(y(6))*params(6)*params(5)*exp(params(5)*y(10))+params(25)*y(58)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))));
T274 = (-(T39*(exp(y(1))*exp(y(11))+y(13)*(-exp(y(11)))-params(6)*params(5)*exp(y(11)*params(5)))));
T275 = y(48)*T274;
T324 = exp(y(16))^(1/params(2));
T326 = (-1)/params(2);
T328 = exp(y(15))*getPowerDeriv(exp(y(15)),T326,1);
T334 = (params(2)-1)/params(2);
T336 = exp(y(15))*getPowerDeriv(exp(y(15)),T334,1);
T346 = exp(y(17))^params(3);
T348 = exp(y(18))^(1-params(3));
T349 = T346*T348;
T350 = T349^T334;
T354 = (1-params(11))*exp(T334*y(23))*T350+params(11)*exp(y(15))^T334;
T356 = getPowerDeriv(T354,params(2)/(params(2)-1),1);
T369 = exp(y(17))^(params(3)-1);
T370 = T349^T326;
T374 = exp(y(16))*getPowerDeriv(exp(y(16)),1/params(2),1);
T383 = exp(y(18))^(-params(3));
T392 = exp(y(15))^T326;
T408 = exp(y(17))*getPowerDeriv(exp(y(17)),params(3),1);
T410 = getPowerDeriv(T349,T334,1);
T412 = (1-params(11))*exp(T334*y(23))*T348*T408*T410;
T417 = T324*exp(T334*y(23))*(1-params(11))*(1-params(3));
T420 = getPowerDeriv(T349,T326,1);
T421 = T348*T408*T420;
T424 = T408*T370*T417+T346*T417*T421;
T430 = T324*exp(T334*y(23))*(1-params(11))*params(3);
T435 = exp(y(17))*getPowerDeriv(exp(y(17)),params(3)-1,1);
T439 = (-(T348*(T369*T421*T430+T370*T430*T435)));
T465 = exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),1);
T468 = (-(params(9)*T465/(1+params(8))));
T469 = getPowerDeriv(T18,(-params(14)),1);
T470 = T468*T469;
T483 = (-(exp(T334*y(23))*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))));
T487 = exp(y(18))*getPowerDeriv(exp(y(18)),1-params(3),1);
T502 = exp(y(18))*getPowerDeriv(exp(y(18)),(-params(3)),1);
T508 = (1-params(11))*exp(T334*y(23))*T410*T346*T487;
T556 = params(9)^((-1)/params(8));
T561 = exp(y(21))*getPowerDeriv(exp(y(21)),1/params(8),1);
T572 = T39*params(6)*params(5)*exp(y(11)*(params(5)-1))-T39*(exp(y(1))-y(13));
T587 = (-(T39*(exp(y(1))*exp(y(11))+(1-exp(y(11)))*y(13)-params(6)*exp(y(11)*params(5)))));
T608 = (-(T39*(exp(y(1))*exp(y(29))+y(30)*(1-exp(y(29)))-params(22)*exp(y(29)*params(21)))));
T621 = T36*y(51)*T572+T39*y(47)+T36*y(46)*(-(T39*(1+exp(y(20))-params(10))))+T36*y(48)*T587+T36*y(49)*(-(y(14)*T39*(1-params(7))))+T36*y(52)*T608+T36*y(53)*(-(y(31)*T39*(1-params(23))));
T648 = T350*(1-params(11))*T334*exp(T334*y(23));
T655 = params(25)^2;
T666 = getPowerDeriv(exp(y(38)-y(24)),params(5)-1,1);
T682 = y(64)*(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))))+y(58)*(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))));
T688 = params(24)^(1-params(4));
T734 = exp(y(27))*y(57)+params(25)*y(44)*params(22)*exp(y(29)*params(21))*exp(y(27))+params(25)*y(57)*(-((1-exp(y(29)))*exp(y(27))))+params(25)*y(63)*(-(exp(y(29))*exp(y(27))));
T768 = (-(T39*(exp(y(1))*exp(y(29))+y(30)*(-exp(y(29)))-params(22)*params(21)*exp(y(29)*params(21)))));
T770 = T36*y(52)*T768;
residual(1) = T21*exp(y(1))*exp(y(4))+(-y(69))+T63+y(69)*params(25);
residual(2) = T21*(-exp(y(2)))+(-y(71))+y(61)*(-(T79*params(4)*exp(y(2)*params(4))))+exp(y(2))*y(44)+params(25)*y(71);
residual(3) = (-y(70))+y(59)*(-(T98*params(4)*exp(params(4)*y(3))))+y(50)*y(14)*T98*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1))+y(44)*exp(y(3))+params(25)*y(70);
residual(4) = T21*T134+(-y(73))+y(65)*(-exp(y(4)))+exp(y(4))*y(64)+params(25)*y(73);
residual(5) = (-y(72))+y(65)*(-exp(y(5)))+exp(y(5))*y(62)+params(25)*y(72);
residual(6) = T188;
residual(7) = T211;
residual(8) = y(61)*exp(y(8))+y(58)*(-(exp(y(8))*params(7)))+params(25)*y(61)*(-(exp(y(8))*(1-params(7))));
residual(9) = y(59)*exp(y(9))+y(56)*(-(params(7)*exp(y(9))))+params(25)*y(59)*(-((1-params(7))*exp(y(9))));
residual(10) = T252+params(25)*y(68)*(-exp(y(10)));
residual(11) = params(25)*y(62)*(-(exp(y(11))*exp(y(7))))+y(51)*T39*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T275+params(25)*y(44)*exp(y(7))*params(6)*params(5)*exp(y(11)*params(5))+params(25)*y(56)*(-(exp(y(7))*(-exp(y(11)))));
residual(12) = exp(y(12))*y(43);
residual(13) = y(49)*(-params(7))+y(48)+T36*y(48)*(-(T39*(1-exp(y(11)))))+T36*T39*y(51);
residual(14) = y(50)*T98*params(4)*exp(y(3)*(params(4)-1))+y(49)+T36*y(49)*(-(T39*(1-params(7))));
residual(15) = y(65)*exp(y(15))+y(40)*(-(params(11)*T324*T328))+y(39)*(-(params(11)*T336*T356));
residual(16) = (-y(74))+y(44)*(-exp(y(16)))+y(42)*(-(T348*T369*T370*exp(T334*y(23))*(1-params(11))*params(3)*T374))+y(41)*(-(T383*T346*T370*T374*exp(T334*y(23))*(1-params(11))*(1-params(3))))+y(40)*(-(T392*params(11)*T374))+exp(y(16))*y(39)+params(25)*y(74);
residual(17) = y(44)*exp(y(17))+params(25)*y(39)*(-(T356*T412))+params(25)*y(41)*(-(T383*T424))+params(25)*y(42)*T439+params(25)*y(43)*(-(exp(y(18)*(1-params(3)))*exp(T334*y(23))*params(3)*exp(y(17)*params(3))))+params(25)*y(44)*(-(exp(y(17))*(1-params(10))));
residual(18) = (T134-exp(y(2)))*T470+y(47)*(-(T470*params(1)/T21))+exp(y(18))*y(45)+y(43)*T483+y(42)*(-(T369*T370*T430*T487+T348*T369*T430*T420*T346*T487))+y(41)*(-(T383*T346*T417*T420*T346*T487+T346*T370*T417*T502))+y(39)*(-(T356*T508))+params(25)*y(47)*(-((-(T470*T21*params(1)))/(T21*T21)));
residual(19) = (T134-exp(y(2)))*exp(y(19))*T469+y(47)*(-(params(1)*exp(y(19))*T469/T21))+exp(y(19))*y(44)+params(25)*y(47)*(-((-(T21*params(1)*exp(y(19))*T469))/(T21*T21)));
residual(20) = y(42)*exp(y(20))+T36*y(46)*(-(T39*exp(y(20))));
residual(21) = y(45)*(-(T556*T561))+y(41)*exp(y(21));
residual(22) = T621;
residual(23) = y(67)+params(25)*y(67)*(-params(15))+y(43)*(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T334*exp(T334*y(23))))+y(42)*(-(T348*T369*T370*T324*(1-params(11))*params(3)*T334*exp(T334*y(23))))+y(41)*(-(T383*T346*T370*T324*(1-params(11))*(1-params(3))*T334*exp(T334*y(23))))+y(39)*(-(T356*T648))+T655*y(67)*(-params(16));
residual(24) = T21*(-(exp(y(4))*params(6)*(-exp(y(38)-y(24)))*T666))+y(66)+T682;
residual(25) = y(60)*(-(T688*params(4)*exp(params(4)*y(25))))+y(54)*y(31)*T688*params(4)*(params(4)-1)*exp((params(4)-1)*y(25))+y(44)*exp(y(25));
residual(26) = y(65)*(-exp(y(26)))+exp(y(26))*y(63);
residual(27) = T734;
residual(28) = y(60)*exp(y(28))+y(57)*(-(params(23)*exp(y(28))))+params(25)*y(60)*(-((1-params(23))*exp(y(28))));
residual(29) = y(63)*(-(exp(y(29))*exp(y(27))))+y(57)*(-(exp(y(27))*(-exp(y(29)))))+y(55)*params(22)*params(21)*(params(21)-1)*exp(y(29)*(params(21)-1))+y(44)*exp(y(27))*params(22)*params(21)*exp(y(29)*params(21))+T770;
residual(30) = y(55)+y(53)*(-params(23))+y(52)+T36*y(52)*(-(T39*(1-exp(y(29)))));
residual(31) = y(54)*T688*params(4)*exp((params(4)-1)*y(25))+y(53)+T36*y(53)*(-(T39*(1-params(23))));
residual(32) = y(69);
residual(33) = y(70);
residual(34) = y(71);
residual(35) = y(72);
residual(36) = y(73);
residual(37) = y(74);
residual(38) = T21*(-(exp(y(4))*params(6)*exp(y(38)-y(24))*T666))+y(68)*exp(y(38));
residual(39) = exp(y(16))-T354^(params(2)/(params(2)-1));
residual(40) = exp(y(1))-params(11)*T324*T392;
residual(41) = exp(y(21))-T383*T346*T370*T417;
residual(42) = exp(y(20))-T348*T369*T370*T430;
residual(43) = exp(y(12))-exp(y(18)*(1-params(3)))*exp(T334*y(23))*exp(y(17)*params(3));
residual(44) = exp(y(6))*params(6)*exp(params(5)*y(10))+params(22)*exp(y(29)*params(21))*exp(y(27))+exp(y(7))*params(6)*exp(y(11)*params(5))+exp(y(25))+exp(y(2))+exp(y(3))+exp(y(19))+exp(y(17))-(exp(y(16))+exp(y(17))*(1-params(10)));
residual(45) = exp(y(18))-T556*exp(y(21))^(1/params(8));
residual(46) = 1-T39*(1+exp(y(20))-params(10));
residual(47) = T39-T21*params(1)/T21;
residual(48) = y(13)-T39*(exp(y(1))*exp(y(11))+(1-exp(y(11)))*y(13)-params(6)*exp(y(11)*params(5)));
residual(49) = y(14)-(y(14)*T39*(1-params(7))+params(7)*y(13));
residual(50) = y(14)*T98*params(4)*exp(y(3)*(params(4)-1))-1;
residual(51) = T572;
residual(52) = y(30)-T39*(exp(y(1))*exp(y(29))+y(30)*(1-exp(y(29)))-params(22)*exp(y(29)*params(21)));
residual(53) = y(31)-(y(31)*T39*(1-params(23))+y(30)*params(23));
residual(54) = y(31)*T688*params(4)*exp((params(4)-1)*y(25))-1;
residual(55) = params(22)*params(21)*exp(y(29)*(params(21)-1))-(exp(y(1))-y(30));
residual(56) = exp(y(7))-(exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(9)));
residual(57) = exp(y(27))-((1-exp(y(29)))*exp(y(27))+params(23)*exp(y(28)));
residual(58) = exp(y(6))-(exp(y(6))*(1-exp((-y(24)))*exp(y(10)))+exp(y(8))*params(7));
residual(59) = exp(y(9))-((1-params(7))*exp(y(9))+T98*exp(params(4)*y(3)));
residual(60) = exp(y(28))-((1-params(23))*exp(y(28))+T688*exp(params(4)*y(25)));
residual(61) = exp(y(8))-(exp(y(8))*(1-params(7))+T79*exp(y(2)*params(4)));
residual(62) = exp(y(5))-exp(y(11))*exp(y(7));
residual(63) = exp(y(26))-exp(y(29))*exp(y(27));
residual(64) = exp(y(4))-exp(y(6))*exp((-y(24)))*exp(y(10));
residual(65) = exp(y(15))-(exp(y(26))+exp(y(4))+exp(y(5)));
residual(66) = y(24)-x(1);
residual(67) = y(23)-(x(2)+y(23)*params(15)+y(23)*params(16));
residual(68) = exp(y(38))-exp(y(10));
residual(69) = y(32);
residual(70) = y(33);
residual(71) = y(34);
residual(72) = y(35);
residual(73) = y(36);
residual(74) = y(37);
lhs =y(75);
rhs =y(67);
residual(75)= lhs-rhs;
lhs =y(76);
rhs =y(23);
residual(76)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(76, 76);

  %
  % Jacobian matrix
  %

T951 = T36*y(52)*(-(T39*exp(y(1))*exp(y(29))))+T36*y(48)*(-(T39*exp(y(1))*exp(y(11))))+T36*y(51)*(-(exp(y(1))*T39));
T977 = params(25)*y(62)*(-(exp(y(11))*exp(y(7))))+params(25)*y(44)*exp(y(7))*params(6)*params(5)*exp(y(11)*params(5))+params(25)*y(56)*(-(exp(y(7))*(-exp(y(11)))));
T1029 = getPowerDeriv(T354,params(2)/(params(2)-1),2);
T1054 = T374+exp(y(16))*exp(y(16))*getPowerDeriv(exp(y(16)),1/params(2),2);
T1081 = y(41)*(-(T383*(T370*T374*exp(T334*y(23))*(1-params(11))*(1-params(3))*T408+T346*T374*exp(T334*y(23))*(1-params(11))*(1-params(3))*T421)));
T1089 = y(42)*(-(T348*(T369*exp(T334*y(23))*(1-params(11))*params(3)*T374*T421+T370*exp(T334*y(23))*(1-params(11))*params(3)*T374*T435)));
T1106 = y(42)*(-(T369*T370*exp(T334*y(23))*(1-params(11))*params(3)*T374*T487+T348*T369*exp(T334*y(23))*(1-params(11))*params(3)*T374*T420*T346*T487))+y(41)*(-(T383*T346*T374*exp(T334*y(23))*(1-params(11))*(1-params(3))*T420*T346*T487+T346*T370*T374*exp(T334*y(23))*(1-params(11))*(1-params(3))*T502));
T1119 = y(42)*(-(T348*T369*T370*T374*(1-params(11))*params(3)*T334*exp(T334*y(23))))+y(41)*(-(T383*T346*T370*T374*(1-params(11))*(1-params(3))*T334*exp(T334*y(23))));
T1128 = T408+exp(y(17))*exp(y(17))*getPowerDeriv(exp(y(17)),params(3),2);
T1130 = getPowerDeriv(T349,T334,2);
T1145 = getPowerDeriv(T349,T326,2);
T1149 = T420*T348*T1128+T348*T408*T348*T408*T1145;
T1231 = y(42)*(-(T348*(T435*T370*T324*(1-params(11))*params(3)*T334*exp(T334*y(23))+T369*T421*T324*(1-params(11))*params(3)*T334*exp(T334*y(23)))));
T1238 = y(41)*(-(T383*(T408*T370*T324*(1-params(11))*(1-params(3))*T334*exp(T334*y(23))+T346*T421*T324*(1-params(11))*(1-params(3))*T334*exp(T334*y(23)))));
T1293 = getPowerDeriv(T18,(-params(14)),2);
T1297 = T469*(-(params(9)*(T465+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),2))/(1+params(8))))+T468*T468*T1293;
T1313 = T487+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),1-params(3),2);
T1402 = y(42)*(-(T487*T369*T370*T324*(1-params(11))*params(3)*T334*exp(T334*y(23))+T348*T369*T420*T346*T487*T324*(1-params(11))*params(3)*T334*exp(T334*y(23))));
T1409 = y(41)*(-(T502*T346*T370*T324*(1-params(11))*(1-params(3))*T334*exp(T334*y(23))+T383*T346*T420*T346*T487*T324*(1-params(11))*(1-params(3))*T334*exp(T334*y(23))));
T1541 = params(25)*y(58)*(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))))+params(25)*y(64)*(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))));
T1542 = getPowerDeriv(exp(y(38)-y(24)),params(5)-1,2);
  g1(1,1)=T21*exp(y(1))*exp(y(4))+T63;
  g1(1,4)=T21*exp(y(1))*exp(y(4));
  g1(1,11)=T36*y(48)*(-(T39*exp(y(1))*exp(y(11))));
  g1(1,18)=exp(y(1))*exp(y(4))*T470;
  g1(1,19)=exp(y(1))*exp(y(4))*exp(y(19))*T469;
  g1(1,22)=T951;
  g1(1,29)=T36*y(52)*(-(T39*exp(y(1))*exp(y(29))));
  g1(1,40)=exp(y(1));
  g1(1,48)=T36*(-(T39*exp(y(1))*exp(y(11))));
  g1(1,51)=T36*(-(exp(y(1))*T39));
  g1(1,52)=T36*(-(T39*exp(y(1))*exp(y(29))));
  g1(1,55)=(-exp(y(1)));
  g1(1,69)=(-1)+params(25);
  g1(2,2)=T21*(-exp(y(2)))+exp(y(2))*y(44)+y(61)*(-(T79*params(4)*params(4)*exp(y(2)*params(4))));
  g1(2,18)=(-exp(y(2)))*T470;
  g1(2,19)=(-exp(y(2)))*exp(y(19))*T469;
  g1(2,44)=exp(y(2));
  g1(2,61)=(-(T79*params(4)*exp(y(2)*params(4))));
  g1(2,71)=(-1)+params(25);
  g1(3,3)=y(59)*(-(T98*params(4)*params(4)*exp(params(4)*y(3))))+y(44)*exp(y(3))+y(50)*y(14)*T98*params(4)*(params(4)-1)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,14)=y(50)*T98*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,44)=exp(y(3));
  g1(3,50)=y(14)*T98*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,59)=(-(T98*params(4)*exp(params(4)*y(3))));
  g1(3,70)=(-1)+params(25);
  g1(4,1)=T21*exp(y(1))*exp(y(4));
  g1(4,4)=T21*T134+y(65)*(-exp(y(4)))+exp(y(4))*y(64);
  g1(4,18)=T134*T470;
  g1(4,19)=T134*exp(y(19))*T469;
  g1(4,24)=T21*(-(exp(y(4))*params(6)*(-exp(y(38)-y(24)))*T666));
  g1(4,38)=T21*(-(exp(y(4))*params(6)*exp(y(38)-y(24))*T666));
  g1(4,64)=exp(y(4));
  g1(4,65)=(-exp(y(4)));
  g1(4,73)=(-1)+params(25);
  g1(5,5)=y(65)*(-exp(y(5)))+exp(y(5))*y(62);
  g1(5,62)=exp(y(5));
  g1(5,65)=(-exp(y(5)));
  g1(5,72)=(-1)+params(25);
  g1(6,6)=T188;
  g1(6,10)=T252;
  g1(6,24)=T1541;
  g1(6,44)=params(25)*exp(y(6))*params(6)*exp(params(5)*y(10));
  g1(6,58)=exp(y(6))+params(25)*(-(exp(y(6))*(1-exp((-y(24)))*exp(y(10)))));
  g1(6,64)=params(25)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(7,7)=T211;
  g1(7,11)=T977;
  g1(7,44)=params(25)*exp(y(7))*params(6)*exp(y(11)*params(5));
  g1(7,56)=exp(y(7))+params(25)*(-(exp(y(7))*(1-exp(y(11)))));
  g1(7,62)=params(25)*(-(exp(y(11))*exp(y(7))));
  g1(8,8)=y(61)*exp(y(8))+y(58)*(-(exp(y(8))*params(7)))+params(25)*y(61)*(-(exp(y(8))*(1-params(7))));
  g1(8,58)=(-(exp(y(8))*params(7)));
  g1(8,61)=exp(y(8))+params(25)*(-(exp(y(8))*(1-params(7))));
  g1(9,9)=y(59)*exp(y(9))+y(56)*(-(params(7)*exp(y(9))))+params(25)*y(59)*(-((1-params(7))*exp(y(9))));
  g1(9,56)=(-(params(7)*exp(y(9))));
  g1(9,59)=exp(y(9))+params(25)*(-((1-params(7))*exp(y(9))));
  g1(10,6)=T252;
  g1(10,10)=params(25)*y(68)*(-exp(y(10)))+params(25)*y(64)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))))+params(25)*y(58)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))))+params(25)*y(44)*exp(y(6))*params(6)*params(5)*params(5)*exp(params(5)*y(10));
  g1(10,24)=T1541;
  g1(10,44)=params(25)*exp(y(6))*params(6)*params(5)*exp(params(5)*y(10));
  g1(10,58)=params(25)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))));
  g1(10,64)=params(25)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(10,68)=params(25)*(-exp(y(10)));
  g1(11,1)=y(48)*(-(T39*exp(y(1))*exp(y(11))));
  g1(11,7)=T977;
  g1(11,11)=params(25)*y(62)*(-(exp(y(11))*exp(y(7))))+params(25)*y(56)*(-(exp(y(7))*(-exp(y(11)))))+y(51)*T39*params(6)*params(5)*(params(5)-1)*(params(5)-1)*exp(y(11)*(params(5)-1))+y(48)*(-(T39*(exp(y(1))*exp(y(11))+y(13)*(-exp(y(11)))-params(6)*params(5)*params(5)*exp(y(11)*params(5)))))+params(25)*y(44)*exp(y(7))*params(6)*params(5)*params(5)*exp(y(11)*params(5));
  g1(11,13)=y(48)*(-(T39*(-exp(y(11)))));
  g1(11,22)=y(51)*T39*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T275;
  g1(11,44)=params(25)*exp(y(7))*params(6)*params(5)*exp(y(11)*params(5));
  g1(11,48)=T274;
  g1(11,51)=T39*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1));
  g1(11,56)=params(25)*(-(exp(y(7))*(-exp(y(11)))));
  g1(11,62)=params(25)*(-(exp(y(11))*exp(y(7))));
  g1(12,12)=exp(y(12))*y(43);
  g1(12,43)=exp(y(12));
  g1(13,11)=T36*y(48)*(-(T39*(-exp(y(11)))));
  g1(13,22)=T36*y(48)*(-(T39*(1-exp(y(11)))))+T36*T39*y(51);
  g1(13,48)=1+T36*(-(T39*(1-exp(y(11)))));
  g1(13,49)=(-params(7));
  g1(13,51)=T36*T39;
  g1(14,3)=y(50)*T98*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(14,22)=T36*y(49)*(-(T39*(1-params(7))));
  g1(14,49)=1+T36*(-(T39*(1-params(7))));
  g1(14,50)=T98*params(4)*exp(y(3)*(params(4)-1));
  g1(15,15)=y(65)*exp(y(15))+y(40)*(-(params(11)*T324*(T328+exp(y(15))*exp(y(15))*getPowerDeriv(exp(y(15)),T326,2))))+y(39)*(-(T356*params(11)*(T336+exp(y(15))*exp(y(15))*getPowerDeriv(exp(y(15)),T334,2))+params(11)*T336*params(11)*T336*T1029));
  g1(15,16)=y(40)*(-(T328*params(11)*T374));
  g1(15,17)=y(39)*(-(params(11)*T336*T412*T1029));
  g1(15,18)=y(39)*(-(params(11)*T336*T508*T1029));
  g1(15,23)=y(39)*(-(params(11)*T336*T648*T1029));
  g1(15,39)=(-(params(11)*T336*T356));
  g1(15,40)=(-(params(11)*T324*T328));
  g1(15,65)=exp(y(15));
  g1(16,15)=y(40)*(-(T328*params(11)*T374));
  g1(16,16)=y(44)*(-exp(y(16)))+y(42)*(-(T348*T369*T370*exp(T334*y(23))*(1-params(11))*params(3)*T1054))+y(41)*(-(T383*T346*T370*exp(T334*y(23))*(1-params(11))*(1-params(3))*T1054))+exp(y(16))*y(39)+y(40)*(-(T392*params(11)*T1054));
  g1(16,17)=T1081+T1089;
  g1(16,18)=T1106;
  g1(16,23)=T1119;
  g1(16,39)=exp(y(16));
  g1(16,40)=(-(T392*params(11)*T374));
  g1(16,41)=(-(T383*T346*T370*T374*exp(T334*y(23))*(1-params(11))*(1-params(3))));
  g1(16,42)=(-(T348*T369*T370*exp(T334*y(23))*(1-params(11))*params(3)*T374));
  g1(16,44)=(-exp(y(16)));
  g1(16,74)=(-1)+params(25);
  g1(17,15)=params(25)*y(39)*(-(T412*params(11)*T336*T1029));
  g1(17,16)=params(25)*T1081+params(25)*T1089;
  g1(17,17)=y(44)*exp(y(17))+params(25)*y(44)*(-(exp(y(17))*(1-params(10))))+params(25)*y(39)*(-(T412*T412*T1029+T356*(1-params(11))*exp(T334*y(23))*(T410*T348*T1128+T348*T408*T348*T408*T1130)))+params(25)*y(41)*(-(T383*(T370*T417*T1128+T408*T417*T421+T408*T417*T421+T346*T417*T1149)))+params(25)*y(42)*(-(T348*(T421*T430*T435+T369*T430*T1149+T421*T430*T435+T370*T430*(T435+exp(y(17))*exp(y(17))*getPowerDeriv(exp(y(17)),params(3)-1,2)))))+params(25)*y(43)*(-(exp(y(18)*(1-params(3)))*exp(T334*y(23))*params(3)*params(3)*exp(y(17)*params(3))));
  g1(17,18)=params(25)*y(39)*(-(T412*T508*T1029+T356*(1-params(11))*exp(T334*y(23))*(T410*T408*T487+T348*T408*T346*T487*T1130)))+params(25)*y(41)*(-(T424*T502+T383*(T408*T417*T420*T346*T487+T346*T417*(T420*T408*T487+T348*T408*T346*T487*T1145))))+params(25)*y(42)*(-((T369*T421*T430+T370*T430*T435)*T487+T348*(T435*T430*T420*T346*T487+T369*T430*(T420*T408*T487+T348*T408*T346*T487*T1145))))+params(25)*y(43)*(-(exp(T334*y(23))*params(3)*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))));
  g1(17,23)=params(25)*y(39)*(-(T356*T348*T408*T410*(1-params(11))*T334*exp(T334*y(23))+T412*T648*T1029))+params(25)*T1238+params(25)*T1231+params(25)*y(43)*(-(exp(y(18)*(1-params(3)))*params(3)*exp(y(17)*params(3))*T334*exp(T334*y(23))));
  g1(17,39)=params(25)*(-(T356*T412));
  g1(17,41)=params(25)*(-(T383*T424));
  g1(17,42)=params(25)*T439;
  g1(17,43)=params(25)*(-(exp(y(18)*(1-params(3)))*exp(T334*y(23))*params(3)*exp(y(17)*params(3))));
  g1(17,44)=exp(y(17))+params(25)*(-(exp(y(17))*(1-params(10))));
  g1(18,1)=exp(y(1))*exp(y(4))*T470;
  g1(18,2)=(-exp(y(2)))*T470;
  g1(18,4)=T134*T470;
  g1(18,15)=y(39)*(-(T508*params(11)*T336*T1029));
  g1(18,16)=T1106;
  g1(18,17)=y(43)*(-(exp(T334*y(23))*params(3)*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))))+y(42)*(-((T369*T421*T430+T370*T430*T435)*T487+T348*(T435*T430*T420*T346*T487+T369*T430*(T346*T487*T348*T408*T1145+T420*T408*T487))))+y(41)*(-(T383*(T408*T417*T420*T346*T487+T346*T417*(T346*T487*T348*T408*T1145+T420*T408*T487))+T424*T502))+y(39)*(-(T508*T412*T1029+T356*(1-params(11))*exp(T334*y(23))*(T346*T487*T348*T408*T1130+T410*T408*T487)));
  g1(18,18)=(T134-exp(y(2)))*T1297+y(47)*(-((T21*params(1)*T1297-T470*T470*params(1))/(T21*T21)))+exp(y(18))*y(45)+y(43)*(-(exp(T334*y(23))*exp(y(17)*params(3))*(1-params(3))*(1-params(3))*exp(y(18)*(1-params(3)))))+y(42)*(-(T487*T369*T430*T420*T346*T487+T369*T370*T430*T1313+T487*T369*T430*T420*T346*T487+T348*T369*T430*(T346*T487*T346*T487*T1145+T420*T346*T1313)))+y(41)*(-(T346*T417*T420*T346*T487*T502+T383*T346*T417*(T346*T487*T346*T487*T1145+T420*T346*T1313)+T346*T417*T420*T346*T487*T502+T346*T370*T417*(T502+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),(-params(3)),2))))+y(39)*(-(T508*T508*T1029+T356*(1-params(11))*exp(T334*y(23))*(T346*T487*T346*T487*T1130+T410*T346*T1313)))+params(25)*y(47)*(-((T21*T21*(-(T470*T470*params(1)+T21*params(1)*T1297))-(-(T470*T21*params(1)))*(T21*T470+T21*T470))/(T21*T21*T21*T21)));
  g1(18,19)=(T134-exp(y(2)))*T468*exp(y(19))*T1293+y(47)*(-((T21*params(1)*T468*exp(y(19))*T1293-T470*params(1)*exp(y(19))*T469)/(T21*T21)))+params(25)*y(47)*(-((T21*T21*(-(T470*params(1)*exp(y(19))*T469+T21*params(1)*T468*exp(y(19))*T1293))-(-(T470*T21*params(1)))*(T21*exp(y(19))*T469+T21*exp(y(19))*T469))/(T21*T21*T21*T21)));
  g1(18,23)=y(43)*(-((1-params(3))*exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T334*exp(T334*y(23))))+T1402+T1409+y(39)*(-(T356*T410*T346*T487*(1-params(11))*T334*exp(T334*y(23))+T508*T648*T1029));
  g1(18,24)=T470*(-(exp(y(4))*params(6)*(-exp(y(38)-y(24)))*T666));
  g1(18,38)=T470*(-(exp(y(4))*params(6)*exp(y(38)-y(24))*T666));
  g1(18,39)=(-(T356*T508));
  g1(18,41)=(-(T383*T346*T417*T420*T346*T487+T346*T370*T417*T502));
  g1(18,42)=(-(T369*T370*T430*T487+T348*T369*T430*T420*T346*T487));
  g1(18,43)=T483;
  g1(18,45)=exp(y(18));
  g1(18,47)=(-(T470*params(1)/T21))+params(25)*(-((-(T470*T21*params(1)))/(T21*T21)));
  g1(19,1)=exp(y(1))*exp(y(4))*exp(y(19))*T469;
  g1(19,2)=(-exp(y(2)))*exp(y(19))*T469;
  g1(19,4)=T134*exp(y(19))*T469;
  g1(19,18)=(T134-exp(y(2)))*exp(y(19))*T468*T1293+y(47)*(-((T21*params(1)*exp(y(19))*T468*T1293-T470*params(1)*exp(y(19))*T469)/(T21*T21)))+params(25)*y(47)*(-((T21*T21*(-(T470*params(1)*exp(y(19))*T469+T21*params(1)*exp(y(19))*T468*T1293))-(-(T21*params(1)*exp(y(19))*T469))*(T21*T470+T21*T470))/(T21*T21*T21*T21)));
  g1(19,19)=(T134-exp(y(2)))*(exp(y(19))*T469+exp(y(19))*exp(y(19))*T1293)+y(47)*(-((T21*params(1)*(exp(y(19))*T469+exp(y(19))*exp(y(19))*T1293)-exp(y(19))*T469*params(1)*exp(y(19))*T469)/(T21*T21)))+exp(y(19))*y(44)+params(25)*y(47)*(-((T21*T21*(-(exp(y(19))*T469*params(1)*exp(y(19))*T469+T21*params(1)*(exp(y(19))*T469+exp(y(19))*exp(y(19))*T1293)))-(-(T21*params(1)*exp(y(19))*T469))*(T21*exp(y(19))*T469+T21*exp(y(19))*T469))/(T21*T21*T21*T21)));
  g1(19,24)=exp(y(19))*T469*(-(exp(y(4))*params(6)*(-exp(y(38)-y(24)))*T666));
  g1(19,38)=exp(y(19))*T469*(-(exp(y(4))*params(6)*exp(y(38)-y(24))*T666));
  g1(19,44)=exp(y(19));
  g1(19,47)=(-(params(1)*exp(y(19))*T469/T21))+params(25)*(-((-(T21*params(1)*exp(y(19))*T469))/(T21*T21)));
  g1(20,20)=y(42)*exp(y(20))+T36*y(46)*(-(T39*exp(y(20))));
  g1(20,22)=T36*y(46)*(-(T39*exp(y(20))));
  g1(20,42)=exp(y(20));
  g1(20,46)=T36*(-(T39*exp(y(20))));
  g1(21,21)=y(41)*exp(y(21))+y(45)*(-(T556*(T561+exp(y(21))*exp(y(21))*getPowerDeriv(exp(y(21)),1/params(8),2))));
  g1(21,41)=exp(y(21));
  g1(21,45)=(-(T556*T561));
  g1(22,1)=T951;
  g1(22,11)=T36*y(51)*T39*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T36*T275;
  g1(22,13)=T36*y(48)*(-(T39*(1-exp(y(11)))))+T36*T39*y(51);
  g1(22,14)=T36*y(49)*(-(T39*(1-params(7))));
  g1(22,20)=T36*y(46)*(-(T39*exp(y(20))));
  g1(22,22)=T621;
  g1(22,29)=T770;
  g1(22,30)=T36*y(52)*(-(T39*(1-exp(y(29)))));
  g1(22,31)=T36*y(53)*(-(T39*(1-params(23))));
  g1(22,46)=T36*(-(T39*(1+exp(y(20))-params(10))));
  g1(22,47)=T39;
  g1(22,48)=T36*T587;
  g1(22,49)=T36*(-(y(14)*T39*(1-params(7))));
  g1(22,51)=T36*T572;
  g1(22,52)=T36*T608;
  g1(22,53)=T36*(-(y(31)*T39*(1-params(23))));
  g1(23,15)=y(39)*(-(T648*params(11)*T336*T1029));
  g1(23,16)=T1119;
  g1(23,17)=y(43)*(-(exp(y(18)*(1-params(3)))*params(3)*exp(y(17)*params(3))*T334*exp(T334*y(23))))+T1231+T1238+y(39)*(-(T648*T412*T1029+T356*T348*T408*T410*(1-params(11))*T334*exp(T334*y(23))));
  g1(23,18)=y(43)*(-((1-params(3))*exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T334*exp(T334*y(23))))+T1402+T1409+y(39)*(-(T648*T508*T1029+T356*T410*T346*T487*(1-params(11))*T334*exp(T334*y(23))));
  g1(23,23)=y(43)*(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T334*T334*exp(T334*y(23))))+y(42)*(-(T348*T369*T370*T324*(1-params(11))*params(3)*T334*T334*exp(T334*y(23))))+y(41)*(-(T383*T346*T370*T324*(1-params(11))*(1-params(3))*T334*T334*exp(T334*y(23))))+y(39)*(-(T648*T648*T1029+T356*T350*(1-params(11))*T334*T334*exp(T334*y(23))));
  g1(23,39)=(-(T356*T648));
  g1(23,41)=(-(T383*T346*T370*T324*(1-params(11))*(1-params(3))*T334*exp(T334*y(23))));
  g1(23,42)=(-(T348*T369*T370*T324*(1-params(11))*params(3)*T334*exp(T334*y(23))));
  g1(23,43)=(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T334*exp(T334*y(23))));
  g1(23,67)=1+params(25)*(-params(15))+T655*(-params(16));
  g1(24,4)=T21*(-(exp(y(4))*params(6)*(-exp(y(38)-y(24)))*T666));
  g1(24,6)=T682;
  g1(24,10)=T682;
  g1(24,18)=T470*(-(exp(y(4))*params(6)*(-exp(y(38)-y(24)))*T666));
  g1(24,19)=exp(y(19))*T469*(-(exp(y(4))*params(6)*(-exp(y(38)-y(24)))*T666));
  g1(24,24)=T21*(-(exp(y(4))*params(6)*(exp(y(38)-y(24))*T666+(-exp(y(38)-y(24)))*(-exp(y(38)-y(24)))*T1542)))+y(64)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))))+y(58)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))));
  g1(24,38)=T21*(-(exp(y(4))*params(6)*((-exp(y(38)-y(24)))*T666+(-exp(y(38)-y(24)))*exp(y(38)-y(24))*T1542)));
  g1(24,58)=(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))));
  g1(24,64)=(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))));
  g1(24,66)=1;
  g1(25,25)=y(60)*(-(T688*params(4)*params(4)*exp(params(4)*y(25))))+y(44)*exp(y(25))+y(54)*y(31)*T688*params(4)*(params(4)-1)*(params(4)-1)*exp((params(4)-1)*y(25));
  g1(25,31)=y(54)*T688*params(4)*(params(4)-1)*exp((params(4)-1)*y(25));
  g1(25,44)=exp(y(25));
  g1(25,54)=y(31)*T688*params(4)*(params(4)-1)*exp((params(4)-1)*y(25));
  g1(25,60)=(-(T688*params(4)*exp(params(4)*y(25))));
  g1(26,26)=y(65)*(-exp(y(26)))+exp(y(26))*y(63);
  g1(26,63)=exp(y(26));
  g1(26,65)=(-exp(y(26)));
  g1(27,27)=T734;
  g1(27,29)=params(25)*y(63)*(-(exp(y(29))*exp(y(27))))+params(25)*y(44)*exp(y(27))*params(22)*params(21)*exp(y(29)*params(21))+params(25)*y(57)*(-(exp(y(27))*(-exp(y(29)))));
  g1(27,44)=params(25)*params(22)*exp(y(29)*params(21))*exp(y(27));
  g1(27,57)=exp(y(27))+params(25)*(-((1-exp(y(29)))*exp(y(27))));
  g1(27,63)=params(25)*(-(exp(y(29))*exp(y(27))));
  g1(28,28)=y(60)*exp(y(28))+y(57)*(-(params(23)*exp(y(28))))+params(25)*y(60)*(-((1-params(23))*exp(y(28))));
  g1(28,57)=(-(params(23)*exp(y(28))));
  g1(28,60)=exp(y(28))+params(25)*(-((1-params(23))*exp(y(28))));
  g1(29,1)=T36*y(52)*(-(T39*exp(y(1))*exp(y(29))));
  g1(29,22)=T770;
  g1(29,27)=y(63)*(-(exp(y(29))*exp(y(27))))+y(57)*(-(exp(y(27))*(-exp(y(29)))))+y(44)*exp(y(27))*params(22)*params(21)*exp(y(29)*params(21));
  g1(29,29)=y(63)*(-(exp(y(29))*exp(y(27))))+y(57)*(-(exp(y(27))*(-exp(y(29)))))+y(55)*params(22)*params(21)*(params(21)-1)*(params(21)-1)*exp(y(29)*(params(21)-1))+y(44)*exp(y(27))*params(22)*params(21)*params(21)*exp(y(29)*params(21))+T36*y(52)*(-(T39*(exp(y(1))*exp(y(29))+y(30)*(-exp(y(29)))-params(22)*params(21)*params(21)*exp(y(29)*params(21)))));
  g1(29,30)=T36*y(52)*(-(T39*(-exp(y(29)))));
  g1(29,44)=exp(y(27))*params(22)*params(21)*exp(y(29)*params(21));
  g1(29,52)=T36*T768;
  g1(29,55)=params(22)*params(21)*(params(21)-1)*exp(y(29)*(params(21)-1));
  g1(29,57)=(-(exp(y(27))*(-exp(y(29)))));
  g1(29,63)=(-(exp(y(29))*exp(y(27))));
  g1(30,22)=T36*y(52)*(-(T39*(1-exp(y(29)))));
  g1(30,29)=T36*y(52)*(-(T39*(-exp(y(29)))));
  g1(30,52)=1+T36*(-(T39*(1-exp(y(29)))));
  g1(30,53)=(-params(23));
  g1(30,55)=1;
  g1(31,22)=T36*y(53)*(-(T39*(1-params(23))));
  g1(31,25)=y(54)*T688*params(4)*(params(4)-1)*exp((params(4)-1)*y(25));
  g1(31,53)=1+T36*(-(T39*(1-params(23))));
  g1(31,54)=T688*params(4)*exp((params(4)-1)*y(25));
  g1(32,69)=1;
  g1(33,70)=1;
  g1(34,71)=1;
  g1(35,72)=1;
  g1(36,73)=1;
  g1(37,74)=1;
  g1(38,4)=T21*(-(exp(y(4))*params(6)*exp(y(38)-y(24))*T666));
  g1(38,18)=T470*(-(exp(y(4))*params(6)*exp(y(38)-y(24))*T666));
  g1(38,19)=exp(y(19))*T469*(-(exp(y(4))*params(6)*exp(y(38)-y(24))*T666));
  g1(38,24)=T21*(-(exp(y(4))*params(6)*((-exp(y(38)-y(24)))*T666+exp(y(38)-y(24))*(-exp(y(38)-y(24)))*T1542)));
  g1(38,38)=y(68)*exp(y(38))+T21*(-(exp(y(4))*params(6)*(exp(y(38)-y(24))*T666+exp(y(38)-y(24))*exp(y(38)-y(24))*T1542)));
  g1(38,68)=exp(y(38));
  g1(39,15)=(-(params(11)*T336*T356));
  g1(39,16)=exp(y(16));
  g1(39,17)=(-(T356*T412));
  g1(39,18)=(-(T356*T508));
  g1(39,23)=(-(T356*T648));
  g1(40,1)=exp(y(1));
  g1(40,15)=(-(params(11)*T324*T328));
  g1(40,16)=(-(T392*params(11)*T374));
  g1(41,16)=(-(T383*T346*T370*T374*exp(T334*y(23))*(1-params(11))*(1-params(3))));
  g1(41,17)=(-(T383*T424));
  g1(41,18)=(-(T383*T346*T417*T420*T346*T487+T346*T370*T417*T502));
  g1(41,21)=exp(y(21));
  g1(41,23)=(-(T383*T346*T370*T324*(1-params(11))*(1-params(3))*T334*exp(T334*y(23))));
  g1(42,16)=(-(T348*T369*T370*exp(T334*y(23))*(1-params(11))*params(3)*T374));
  g1(42,17)=T439;
  g1(42,18)=(-(T369*T370*T430*T487+T348*T369*T430*T420*T346*T487));
  g1(42,20)=exp(y(20));
  g1(42,23)=(-(T348*T369*T370*T324*(1-params(11))*params(3)*T334*exp(T334*y(23))));
  g1(43,12)=exp(y(12));
  g1(43,17)=(-(exp(y(18)*(1-params(3)))*exp(T334*y(23))*params(3)*exp(y(17)*params(3))));
  g1(43,18)=T483;
  g1(43,23)=(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T334*exp(T334*y(23))));
  g1(44,2)=exp(y(2));
  g1(44,3)=exp(y(3));
  g1(44,6)=exp(y(6))*params(6)*exp(params(5)*y(10));
  g1(44,7)=exp(y(7))*params(6)*exp(y(11)*params(5));
  g1(44,10)=exp(y(6))*params(6)*params(5)*exp(params(5)*y(10));
  g1(44,11)=exp(y(7))*params(6)*params(5)*exp(y(11)*params(5));
  g1(44,16)=(-exp(y(16)));
  g1(44,17)=exp(y(17))-exp(y(17))*(1-params(10));
  g1(44,19)=exp(y(19));
  g1(44,25)=exp(y(25));
  g1(44,27)=params(22)*exp(y(29)*params(21))*exp(y(27));
  g1(44,29)=exp(y(27))*params(22)*params(21)*exp(y(29)*params(21));
  g1(45,18)=exp(y(18));
  g1(45,21)=(-(T556*T561));
  g1(46,20)=(-(T39*exp(y(20))));
  g1(46,22)=(-(T39*(1+exp(y(20))-params(10))));
  g1(47,18)=(-((T21*T470*params(1)-T470*T21*params(1))/(T21*T21)));
  g1(47,19)=(-((T21*params(1)*exp(y(19))*T469-T21*params(1)*exp(y(19))*T469)/(T21*T21)));
  g1(47,22)=T39;
  g1(48,1)=(-(T39*exp(y(1))*exp(y(11))));
  g1(48,11)=T274;
  g1(48,13)=1-T39*(1-exp(y(11)));
  g1(48,22)=T587;
  g1(49,13)=(-params(7));
  g1(49,14)=1-T39*(1-params(7));
  g1(49,22)=(-(y(14)*T39*(1-params(7))));
  g1(50,3)=y(14)*T98*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(50,14)=T98*params(4)*exp(y(3)*(params(4)-1));
  g1(51,1)=(-(exp(y(1))*T39));
  g1(51,11)=T39*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1));
  g1(51,13)=T39;
  g1(51,22)=T572;
  g1(52,1)=(-(T39*exp(y(1))*exp(y(29))));
  g1(52,22)=T608;
  g1(52,29)=T768;
  g1(52,30)=1-T39*(1-exp(y(29)));
  g1(53,22)=(-(y(31)*T39*(1-params(23))));
  g1(53,30)=(-params(23));
  g1(53,31)=1-T39*(1-params(23));
  g1(54,25)=y(31)*T688*params(4)*(params(4)-1)*exp((params(4)-1)*y(25));
  g1(54,31)=T688*params(4)*exp((params(4)-1)*y(25));
  g1(55,1)=(-exp(y(1)));
  g1(55,29)=params(22)*params(21)*(params(21)-1)*exp(y(29)*(params(21)-1));
  g1(55,30)=1;
  g1(56,7)=exp(y(7))-exp(y(7))*(1-exp(y(11)));
  g1(56,9)=(-(params(7)*exp(y(9))));
  g1(56,11)=(-(exp(y(7))*(-exp(y(11)))));
  g1(57,27)=exp(y(27))-(1-exp(y(29)))*exp(y(27));
  g1(57,28)=(-(params(23)*exp(y(28))));
  g1(57,29)=(-(exp(y(27))*(-exp(y(29)))));
  g1(58,6)=exp(y(6))-exp(y(6))*(1-exp((-y(24)))*exp(y(10)));
  g1(58,8)=(-(exp(y(8))*params(7)));
  g1(58,10)=(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))));
  g1(58,24)=(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))));
  g1(59,3)=(-(T98*params(4)*exp(params(4)*y(3))));
  g1(59,9)=exp(y(9))-(1-params(7))*exp(y(9));
  g1(60,25)=(-(T688*params(4)*exp(params(4)*y(25))));
  g1(60,28)=exp(y(28))-(1-params(23))*exp(y(28));
  g1(61,2)=(-(T79*params(4)*exp(y(2)*params(4))));
  g1(61,8)=exp(y(8))-exp(y(8))*(1-params(7));
  g1(62,5)=exp(y(5));
  g1(62,7)=(-(exp(y(11))*exp(y(7))));
  g1(62,11)=(-(exp(y(11))*exp(y(7))));
  g1(63,26)=exp(y(26));
  g1(63,27)=(-(exp(y(29))*exp(y(27))));
  g1(63,29)=(-(exp(y(29))*exp(y(27))));
  g1(64,4)=exp(y(4));
  g1(64,6)=(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(64,10)=(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(64,24)=(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))));
  g1(65,4)=(-exp(y(4)));
  g1(65,5)=(-exp(y(5)));
  g1(65,15)=exp(y(15));
  g1(65,26)=(-exp(y(26)));
  g1(66,24)=1;
  g1(67,23)=1-(params(15)+params(16));
  g1(68,10)=(-exp(y(10)));
  g1(68,38)=exp(y(38));
  g1(69,32)=1;
  g1(70,33)=1;
  g1(71,34)=1;
  g1(72,35)=1;
  g1(73,36)=1;
  g1(74,37)=1;
  g1(75,67)=(-1);
  g1(75,75)=1;
  g1(76,23)=(-1);
  g1(76,76)=1;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],76,5776);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],76,438976);
end
end
end
end
